<?php
// app/Models/Dusun.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Dusun extends Model
{
    protected $table = 'dusun';
    
    protected $fillable = [
        'desa_id', 'nama_dusun', 'jumlah_rt', 'jumlah_rw',
        'latitude', 'longitude'
    ];

    protected $casts = [
        'latitude' => 'decimal:7',
        'longitude' => 'decimal:7',
    ];

    public function desa()
    {
        return $this->belongsTo(Desa::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function prediksi()
    {
        return $this->hasMany(Prediksi::class);
    }
}
